@extends('layout.main')
@section('content')

@if($data->id_usuario != Auth::guard('usuario')->user()->id_usuario)   
    <script>
        window.location.href = "{{ url('/personal/perfil/'.Auth::guard("usuario")->user()->username.'') }}";
    </script>
@endif  

    <div class="sixteen wide tablet two wide computer column ">
        <div class="ui vertical secondary pointing fluid tabular menu">
            <a class="item active" data-tab="one">Mi perfil</a>
            <a class="item" data-tab="two">Editar</a>
            <a class="item" data-tab="three">Seguridad</a>
        </div>  
    </div>   
    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            <!-- start tab 1 -->
            <div class="ui tab active" data-tab="one">
                <div class="column left floated profileheader">
                    <div class="ui items">
                        <div class="item">
                            <a class="ui small circular image" id="avatar_profile"><img src="{{ asset($data->url_avatar) }}"></a>
                            <div class="middle aligned content">
                                <div class="header">{{ucwords(mb_strtolower($data->nombres))}} {{ucwords(mb_strtolower($data->apellidos))}}</div>
                                <div class="meta"><i class="laptop icon"></i> {{$data->rol->nombre}}</div>
                                <div class="meta"><i class="map marker alternate icon"></i> {{ucwords(mb_strtolower($data->local->nombre))}} ({{ucwords(mb_strtolower($data->local->direccion))}})</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
            <!-- end tab 1 -->
            <!-- start tab 2 -->
            <div class="ui tab" data-tab="two">
                <h4 class="ui dividing header teal centered">EDITAR MIS DATOS</h4>
                <br>
                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_usuario" name="id_usuario" value="{{ $data->id_usuario }}">
                    <input type="hidden" name="id_local" value="{{ $data->id_local }}">
                    <input type="hidden" name="id_rol" value="{{ $data->id_rol }}">
                    <div class="two fields">
                        <div class="field">
                            <label>Nombres</label>
                            <div class="ui small input ">
                              <input type="text" name="nombres" maxlength="50" oninput="$.upperCase(this)" value="{{$data->nombres}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Apellidos</label>
                            <div class="ui small input ">
                              <input type="text" name="apellidos" maxlength="50" oninput="$.upperCase(this)" value="{{$data->apellidos}}">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Usuario</label>
                            <div class="ui small input">
                              <input type="text" name="username" maxlength="20" value="{{$data->username}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>DNI</label>
                            <div class="ui small input ">
                              <input type="text" name="dni" maxlength="8" value="{{$data->dni}}">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Fecha de Nacimiento</label>
                            <div class="ui small input ">
                              <input type="text" name="fecha_nacimiento" class="fecha_pas" value="{{$data->fecha_nacimiento}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Domicilio</label>
                            <div class="ui small input " >
                              <input type="text" name="domicilio" maxlength="100" oninput="$.upperCase(this)" value="{{$data->domicilio}}">
                            </div>
                        </div>
                    </div>   

                    <div class="two fields">
                        <div class="field">
                            <label>Telefono</label>
                            <div class="ui small input ">
                              <input type="text" name="telefono" maxlength="15" value="{{$data->telefono}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Email</label>
                            <div class="ui small input ">
                              <input type="email" name="email" maxlength="50" value="{{$data->email}}">
                            </div>
                        </div>
                    </div> 
            
                    <div class="form_footer" >
                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                    </div>    
                </form>
            </div>   
            <!-- end tab 2 -->
            <!-- start tab 3 -->
            <div class="ui tab" data-tab="three">
                <h4 class="ui dividing header teal centered">CAMBIAR CONTRASEÑA</h4>
                <br>
                <form class="ui form" id="frmEditarPassword" autocomplete="off">
                    <input type="hidden" name="id_usuario" value="{{ $data->id_usuario }}">    
                    <div class="two fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Nueva contraseña</div>
                        </div>
                        <div class="seven wide field">
                            <div class="ui small input">
                                <input type="password" name="new_password" >
                            </div> 
                        </div>
                    </div>
                    <div class="two fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Repita nueva contraseña</div>
                        </div>
                        <div class="seven wide field">
                            <div class="ui small input">
                                <input type="password" name="password" >
                            </div> 
                        </div>
                    </div>
                    <div class="form_footer" >
                        <div class="ui right floated primary button btn_guardar_password"><i class="redo icon"></i>CAMBIAR CONTRASEÑA</div>
                    </div>    
                </form>
            </div> 
            <!-- end tab 3 -->

        </div>
    </div>

    <!--start update modal -->
    <div class="ui small basic modal" id="update_modal">
        <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
        </div>
    </div>
    <!--end update modal -->
    
@stop

@section('scripts')
    <script src="{{ asset('js/usuario/perfil.js') }}"></script>
@stop


