@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE TRASLADO DE PRODUCTOS</h4>
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registro el traslado :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registro el traslado :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Motivo de Traslado :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->descripcion }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Flete del traslado :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">S/ {{ $data->flete }}</div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Local de Origen :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->local_origen->nombre }} ({{ $data->local_origen->direccion }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Local de Destino :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->local_destino->nombre }} ({{ $data->local_destino->direccion }})</div>
                    </div>
                </div>
            </div>


            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned">Marca</th>
                        <th class="center aligned">Codigo Barras</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">Presentacion</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio Venta S/</th>
                        <th class="center aligned">Cantidad Trasladada</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalles as $detalle)
                    <tr data-table="{{ $detalle->id_detalle_traslado }}">
                        <td><a href="{{ url('producto/editar/'.$detalle->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($detalle->producto->nombre)) }}</a></td>
                        <td>{{ $detalle->producto->descripcion }}</td>
                        <td>{{ $detalle->producto->codigo_barras != null ? $detalle->producto->codigo_barras : 'Sin codigo'  }}</td>
                        <td>{{ $detalle->producto->tipo_presentacion->nombre }}</td>
                        <td>{{ $detalle->producto->precio }}</td>

                        <td class="warning">{{ $detalle->cantidad }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
            </div>  

        </div>
    </div>

 
@stop



