@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE RETIRO DE PRODUCTO</h4>
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que retiró el producto :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se retiró el producto :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Motivo de Retiro :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->motivo_retiro }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Cantidad Retirada :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->cantidad_retiro }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Monto Perdido :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">S/ {{ $data->monto_perdido }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Local donde se retiro :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->local->nombre }} ({{ $data->local->direccion }})</div>
                    </div>
                </div>
            </div>


            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned">Marca</th>
                        <th class="center aligned">Codigo Barras</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">Presentacion</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio Venta S/</th>
                        <th class="center aligned">Ubicacion del Producto</th>
                    </tr>
                </thead>
                <tbody id="tbody">

                    <tr>
                        <td><a href="{{ url('producto/editar/'.$data->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->producto->nombre)) }} {{ $data->producto->descripcion}}</a></td>
                        <td>{{ $data->producto->descripcion }}</td>
                        <td>{{ $data->producto->codigo_barras != null ? $data->producto->codigo_barras : 'Sin codigo' }}</td>
                        <td>{{ $data->producto->tipo_presentacion->nombre }}</td>
                        <td>{{ $data->producto->precio }}</td>
                        <td>{{ $data->local->nombre }}</td>
                    </tr>

                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
            </div>  

        </div>
    </div>

 
@stop



