@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">RESUMEN DIARIO DE BOLETAS</h4>
           
            <div class="ui equal width grid">
                <div class="row">
                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="estado_envio">
                            <option value="">Seleccione</option>
                            <option value="TODOS">TODOS</option>
                            <option value="0">ACEPTADOS</option>
                            <option value="1">RECHAZADOS</option>
                            <option value="2">NO ENVIADOS</option>
                            <option value="3">PENDIENTES</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">N° Resumen</th>
                        <th class="head_table">Tipo de Resumen</th>
                        <th class="head_table">Fecha Emision</th>
                        <th class="head_table">Fecha de Envio</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $resumen)
                    <tr data-table="{{ $resumen->id_resumen }}">
                        <td>{{ $i }}</td>
                        <td>{{ $resumen->nombre_resumen }}</td>
                        <td>{{ $resumen->tipo_comprobante->nombre }}</td>
                        <td>{{ $resumen->fecha_referencia }}</td>
                        <td>{{ $resumen->updated_at }}</td>
                        <td>
                            @if($resumen->estado_envio == "ACEPTADO")
                                <div class="ui green label">{{ $resumen->estado_envio }}</div>
                            @elseif ($resumen->estado_envio == "RECHAZADO")
                                <div class="ui yellow label">{{ $resumen->estado_envio }}</div>
                            @elseif ($resumen->estado_envio == "NO ENVIADO")
                                <div class="ui red label">{{ $resumen->estado_envio }}</div>
                            @elseif ($resumen->estado_envio == "PENDIENTE")
                                <div class="ui purple label">{{ $resumen->estado_envio }}</div> 
                            @endif
                        </td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('resumen/detalles/'.$resumen->id_resumen) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/resumen/listar.js') }}"></script>
@stop



