@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">EMISION DE NOTA DE DEBITO</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">

               <input type="hidden" id="id_venta" name="id_venta" value="{{ $data->id_venta }}">
               <input type="hidden" id="id_tipo_comprobante" name="id_tipo_comprobante" value="4">

                <div class="five fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Cliente</div>
                    </div>
                    <div class="seven wide field">
                        <div class="ui small input ">
                          <input type="text"  readonly value="{{ $data->cliente->nombre }}">
                        </div>
                    </div>
                    <div class="one wide field">
                        <div class="ui fluid large white label">{{ $data->cliente->tipo_documento->nombre }}</div>
                    </div>
                    <div class="two wide field">
                        <div class="ui small input ">
                          <input type="text" readonly value="{{ $data->cliente->numero_documento }}">
                        </div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Numero de Comprobante</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input ">
                          <input type="text" maxlength="20" readonly value="{{ $data->nombre_comprobante }}">
                        </div>
                    </div>
                </div>
                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Nuevo Monto Total</div>
                    </div>

                    <div class="three wide field">
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="monto" value="{{ $data->total_venta }}" placeholder="{{ $data->total_venta }}" maxlength="9">
                        </div> 
                    </div>

                </div>
                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Motivo de la nota</div>
                    </div>
                    <div class="four wide field">
                        <select class="ui fluid small input dropdown" id="motivo_nota" name="motivo_nota">
                            <option value="01">Intereses por mora</option>
                            <option value="02">Aumento en el valor</option>
                            <option value="03">Penalidades / otros conceptos</option>
                        </select>  
                    </div>
                </div>
                

                <div class="five fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Descripcion del motivo</div>
                    </div>
                    <div class="seven wide field">
                        <div class="ui small input ">
                          <input type="text" name="descripcion"  maxlength="200" oninput="$.upperCase(this)" placeholder="Ejemplo: Aplicacion de intereses por no pagar la factura a tiempo">
                        </div>
                    </div>
                    <div class="one wide field">
                        <div class="ui fluid large white label">Fecha</div>
                    </div>
                    <div class="two wide field">
                        <div class="ui small input ">
                          <input type="text" class="hasDate" readonly name="fecha_emision">
                        </div>
                    </div>
                </div>

                <div class="form_footer">
                    <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>EMITIR</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Emitir Nota</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea emitir la nota de debito para esta venta?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Emitir</div>
        </div>
    </div>
    <!--end register modal -->
    
@stop

@section('scripts')
    <script src="{{ asset('js/nota/nuevo_debito.js') }}"></script>
@stop


