@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE DEUDA</h4>
           
            <input type="hidden" id="id_compra" value="{{$data->id_compra}}">
            <input type="hidden" id="id_local" value="{{$data->id_local}}">
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        @if($data->estado == 1)
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la compra :</div>
                        @else
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que anuló la compra :</div>
                        @endif
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        @if($data->estado == 1)
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la compra :</div>           
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>             
                        @else
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se anuló la compra :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->updated_at)) }}</div>                        
                        @endif
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  four wide computer column message_header">Almacen de Destino :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet four wide computer column message_header">Nombre de Proveedor :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column"><a href="{{ url('proveedor/editar/'.$data->id_proveedor) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->proveedor->nombre)) }}</a> </div>
                        <div class="sixteen wide mobile six wide tablet two wide computer column message_header">{{ $data->proveedor->tipo_documento->nombre }} :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column">{{ $data->proveedor->numero_documento }}</div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ !is_null($data->tipo_comprobante) ? $data->tipo_comprobante : 'No especificado' }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Numero de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ !is_null($data->numero_comprobante) ? $data->numero_comprobante : 'No especificado' }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Compra :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ !is_null($data->fecha_compra) ? $data->fecha_compra : 'No especificado' }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total de la Compra :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->total_compra }}</div>
                    </div>
                </div>
            </div>
            
            @if($data->tipo_compra == 'CREDITO')
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Compra :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">AL {{ $data->tipo_compra }}</div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha a pagar la deuda:</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_pago }}</div>
                    </div>
                </div>
            </div>
            @endif


            
            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad comprada" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de compra" data-position="top center" data-inverted="">P. Compra</th>
                        <th class="center aligned">Subtotal</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">P. Venta</th>
                        <th class="center aligned">Ganancia</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalle_compra as $compra)
                    <tr data-table="{{ $compra->id_detalle_compra }}">
                        <td><a href="{{ url('producto/editar/'.$compra->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($compra->producto->nombre)) }} ({{ $compra->producto->tipo_presentacion->nombre }})</a></td>
                        <td>{{ $compra->producto->unidad_medida->nombre }}</td>
                        <td>{{ $compra->cantidad }}</td>
                        <td>{{ $compra->precio_compra_unitario }}</td>
                        <td class="warning">{{ $compra->precio_compra_total }}</td>
                        <td>{{ $compra->precio_venta_unitario }}</td>
                        <td>{{ $compra->utilidad }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                {{-- <div class="ui labeled small input" style="float:right" >
                    <label class="ui blue label">TOTAL S/</label>
                    <input type="text"  value="{{ $data->total_compra }}" size="5" readonly>
                </div>  --}}
                @if($data->estado == 1)
                <div class="ui small right floated orange button btn_anular_deuda"><i class="trash icon"></i>Liquidar Deuda</div>
                @endif
               {{--  <div class="ui small right floated primary button btn_imprimir"><i class="print icon"></i>Imprimir</div> --}}
                
            </div>  

        </div>
    </div>

    <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Liquidar Deuda</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere liquidar esta deuda?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para anular compra"> <i class="checkmark icon"></i>Liquidar</div>
            </div>
        </div>
        <!--end update modal -->


 
@stop

@section('scripts')
    <script src="{{ asset('js/compra/detalles.js') }}"></script>
@stop


