/*================================================================================
Project Name: Seven - Sistema de Ventas
Version: 1.0
Author: Carlos Yasmany
================================================================================*/

var seven = {

    ready : function(){
        /**
         * Inicializamos Componentes
         */
        $('.ui.accordion').accordion();
        $('.ui.dropdown').dropdown();
        $('.ui.search.dropdown').dropdown({ fullTextSearch: true });
        $('.tabular.menu .item').tab();
        $('#sidebar').sidebar('attach events', '#launch_icon');
        $('.ui.checkbox').checkbox();

        $('.fecha').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+100'
        });

        $('.fecha_pas').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+0'
        });

        $('.fecha_fut').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            minDate: 1,
            yearRange: '-0:+100'
        });

        $(".fecha1").datepicker({
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+0',
            dateFormat: "yy-mm-dd",
            onSelect: function(selectedDate) {
                $(".fecha2").datepicker("option", "minDate", selectedDate);
            }
        });
            
        $(".fecha2").datepicker({
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+0',
            minDate: 0,
            dateFormat: "yy-mm-dd",
        });

        $('.fecha_hora').datetimepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true,
            yearRange: '-10:+10',
         });

        //Para cuotas credito
        $('body').on('click', '.fecha_fut2', function(){
                $('.fecha_fut2').datepicker({
                    dateFormat: 'yy-mm-dd', 
                    changeMonth: true, 
                    changeYear: true, 
                    minDate: 1,
                    yearRange: '-0:+100'
                });
        });


        var f = new Date(); 
        $('.hasDate').val(f.getFullYear() +'-'+ ((f.getMonth()+1) > 9 ? f.getMonth()+1 : '0'+(f.getMonth()+1))+'-'+(f.getDate()));

        if($(window).innerWidth() <= 1024) {
            $('#sidebar').sidebar('hide');
            $('#launch_icon').css('display','block');
            $('#pusher').css('margin-right','0px');
        }
        else{
            $('#launch_icon').css('display','none');
            $('#pusher').css('margin-right','260px');
        }

        $(window).resize(function () {
            if ($(window).innerWidth() <= 1024 ) {
                $('#sidebar').sidebar('hide');
                $('#launch_icon').css('display','block');
                $('#pusher').css('margin-right','0px');
            }
            else{
                $('#sidebar').addClass('visible');
                $('#launch_icon').css('display','none');
                $('#pusher').css('margin-right','260px');
                if ($('#pusher').hasClass('dimmed')) {
                    $('#sidebar').sidebar('toggle');
                    setTimeout(function(){ $('#sidebar').addClass('visible'); }, 100);
                }
            }
        });

        /**
         * actualizando boleta factura de formulario de ventas
         */
        $('#select_comprobante_venta').dropdown({
            onChange: function(value, text, $selectedItem) {
                $('#frmNuevo').form('remove prompt', ['numero_documento']);
                $('#frmNuevo').form('remove prompt', ['nombre']);
                $("#tipo_comprobante").val(value);
                $("#tipo_documento").val(value);
 
                if (text == 'FACTURA') {
                    $("#nomb").text("Razon Social");
                    $("#tipo_doc").text("RUC");
                    $('input[name="numero_documento"]').attr('maxlength', 11);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }
                if (text == 'BOLETA') {
                    $("#nomb").text("Nombre del Cliente");
                    $("#tipo_doc").text("DNI");
                    $('input[name="numero_documento"]').attr('maxlength', 8);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        depends : 'nombre',
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        depends : 'numero_documento',
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }

                $.requestApi('/venta/getCorrelativo', {'id_local': __user.id_local, 'id_tipo_comprobante': value}, 'GET', function (resolve) {
                    if (resolve)
                        $('#serie_comprobante').text(resolve.serie);
                        $('#numero_comprobante').text(resolve.numero);
                });
            }
        });

        
        /**
         * actualizando boleta factura de formulario de CONTINGENCIAS
         */
        $('#select_comprobante_contingencia').dropdown({
            onChange: function(value, text, $selectedItem) {
                $('#frmNuevo').form('remove prompt', ['numero_documento']);
                $('#frmNuevo').form('remove prompt', ['nombre']);
                $("#tipo_comprobante").val(value);
                $("#tipo_documento").val(value);
 
                if (text == 'FACTURA') {
                    $("#nomb").text("Razon Social");
                    $("#tipo_doc").text("RUC");
                    $('input[name="numero_documento"]').attr('maxlength', 11);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }
                if (text == 'BOLETA') {
                    $("#nomb").text("Nombre del Cliente");
                    $("#tipo_doc").text("DNI");
                    $('input[name="numero_documento"]').attr('maxlength', 8);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        depends : 'nombre',
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        depends : 'numero_documento',
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }
            }
        });

        /**
         * cargar alerta stock
         */ 
        $._requestApi('/producto_local/alertas', {}, 'GET', function (resolve) {
            if (resolve){
                cargarAlerta(resolve.stock , resolve.vencido, resolve.delivery);
            }
        }); 

        /**
         * Muestar modal de detalle del stock en alertas
         */ 
        $('body').on('click', '.alerta_producto_compra', function(){ 
            
            var id = $(this).data("id");
            var data = {'id_producto' : id, 'id_local': __user.id_local};
            $.requestApi('/producto_local/getByIdLocal', data, 'GET', function (resolve) {
                if (resolve) {

                    $('#alerta_1').text(resolve.producto.codigo_barras); 
                    $('#alerta_2').text(resolve.producto.nombre); 
                    $('#alerta_3').text(resolve.producto.descripcion); 
                    $('#alerta_4').text(resolve.producto.tipo_producto); 
                    $('#alerta_5').text(resolve.producto.fecha_vencimiento); 
                    $('#alerta_6').text(resolve.producto.tipo_presentacion.nombre); 
                    $('#alerta_7').text(resolve.producto.unidad_medida.nombre +" ("+ resolve.producto.unidad_medida.abreviatura +")"); 
                    $('#alerta_8').text(resolve.producto.situacion_impuesto); 
                    $('#alerta_9').text(resolve.producto.tipo_impuesto); 
                    $('#alerta_10').text(resolve.producto.valor_impuesto+' %'); 
                    $('#alerta_11').text('S/ '+resolve.producto.precio); 

                    $('#alerta_12').text(resolve.local.nombre +' ('+ resolve.local.direccion+')'); 
                    $('#alerta_13').text(Math.round((resolve.stock-1000000)*100)/100 +' '+resolve.producto.unidad_medida.abreviatura); 
                    $('#alerta_14').text(Math.round(resolve.stock_alerta) +' '+resolve.producto.unidad_medida.abreviatura); 

                    $('#btn_editar_alerta').data('id',resolve.id_producto);

                    $('#detalles_modal_alerta').modal('show'); 
                }
            });
        });

        /**
         * Redirige a la ventana de PEDIDOS pendientes
         */ 
        $('body').on('click', '.alerta_pedido_delivery', function(){ 
            
            location.href = APP_URL+"/delivery/estado_delivery/0";
        });

        /**
         * Redirige a la ventana de Productos alerta
         */ 

        $('body').on('click', '#btn_editar_alerta', function(){ 
            
            var id = $('#btn_editar_alerta').data('id');
            location.href = APP_URL+"/producto/editar/"+id; 

        });
   
    },
}


$(document).ready(seven.ready);

function cargarAlerta(stock, vencido, delivery) {
    count = 0;

    if (delivery > 0) {
        $("#item_alertas").append('<div class="item alerta_pedido_delivery"><div class="ui violet label">Delivery</div><div class="ui pink label circular" style="margin-left: -5px">'+delivery+'</div>'+'Pedidos pendientes'+'</div>');
        count = count + 1;
    }

    stock.forEach(function (elem) {
        var nombre = elem.producto.nombre.toLowerCase();
        if ((parseInt(elem.stock-1000000)) < parseInt(elem.stock_alerta) ) {
            $("#item_alertas").append('<div class="item alerta_producto_compra" data-id="'+elem.id_producto+'"><div class="ui violet label">En stock</div><div class="ui pink label circular" style="margin-left: -5px">'+Math.round(elem.stock-1000000)+'</div>'+nombre.charAt(0).toUpperCase() + nombre.substr(1)+'</div>');
            count = count + 1;
        }
    });

    vencido.forEach(function (elem) {
        var nombre = elem.nombre.toLowerCase();
        
        $("#item_alertas").append('<div class="item alerta_producto_compra" data-id="'+elem.id_producto+'"><div class="ui violet label">Vencidos</div><div class="ui pink label circular" style="margin-left: -5px">'+Math.round(elem.stock-1000000)+'</div>'+nombre.charAt(0).toUpperCase() + nombre.substr(1)+'</div>');
        count = count + 1;
        
    });


    $('#numero_alertas').text(count); 
}