
var BASE_URL  = window.location.href;

var APP_URL  = window.location.origin+'/seven_master/public'; //LOCALHOST

//var APP_URL  = window.location.origin+'/public'; //PRODUCCION

$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
		    numero_documento: {
		        rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'integer', prompt : 'Ingrese solo números'}
                ]
		    },
		    nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            direccion: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            email: {
                optional: true,
		        rules: [{ type : 'email', prompt : 'Imgrese un email valido'}]
            },
            telefono: {
		        rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'integer', prompt : 'Ingrese solo números'}
                ]
		    },
    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {
  		var count=$("#tbody tr:first > td").length;
    	if (count > 0 && ($('#total_venta') !== "")) {
    		if ($('#total_venta').val() !== "") {
			  	if ($('#frmNuevo').form('is valid')) {
					$('#register_modal').modal({
		  				closable: false,
				    	onApprove : function() {
				    		sendForm();
					    }
			  		}).modal('show');  
				} else {
					$('#frmNuevo').form('validate form');
				}
			} else {
				swal("Los precios", "de los productos no son validos", "warning");
			}
		} else {
			swal("Por favor", "agregue algun producto a la lista", "warning");
		}
  	});	

  	function sendForm() {

        var data = $('#frmNuevo').serialize();

        $.requestApi('/api/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
                var url = APP_URL+"/../pdf/ComprobanteDeliveryCorreo.php?id_delivery="+resolve.id_delivery+"&email="+resolve.email;
                var parametros = "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no , width=800, height=600";
                window.open(url, "Comprobante Electronico", parametros);

                swal({title: "Pedido Procesado!", text: "Nos comunicaremos con Usted para coordinar la entrega de su pedido", icon: "success", button: "OK"})
                .then(() => {location.href = BASE_URL});
	        }
	    }); 
  
        return false;
	};


	/******************************************************************************/
	/* buscar cliente con Keypress
	/******************************************************************************/

	$('#numero_documento').on('keyup', function(){
  		$(this).val($(this).val().trim());
    });

  	$('#numero_documento').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var num = $('#numero_documento').val();
    		buscarDocumentoCliente2(num);
    	}	
	});

    $('#loading_doc').on('click', function() {
    	var num = $('#numero_documento').val();
    	buscarDocumentoCliente2(num);
  	});

  	function buscarDocumentoCliente2(num) 
  	{	
    	if ( num.length == 11  ) 
    	{
    		$("#loading_doc").addClass('loading');
    		$._requestApi('/api/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#nombre_cliente').val(resolve.nombre);
		        	resolve.direccion !== '-' ? $('#direccion').val(resolve.direccion) : $('#direccion').val(' ');
		        }
		        else {
		        	$('#nombre_cliente').val('');
		        	$('#direccion').val('');
		        }
		        $("#loading_doc").removeClass('loading');
        	}, function () {
        		$("#loading_doc").removeClass('loading');
        	});
    	}

    	if ( num.length == 8 ) 
    	{
    		$("#loading_doc").addClass('loading');
    		$._requestApi('/api/getDniByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#nombre_cliente').val(resolve.nombre.trim());
		        	resolve.nombre.trim() !== '' ? $('#direccion').val(' ') : $('#direccion').val('');
		        }
		        else {
		        	$('#nombre_cliente').val('');
		        	$('#direccion').val('');
		        }
		        $("#loading_doc").removeClass('loading');
        	}, function () {
        		$("#loading_doc").removeClass('loading');
        	});

    	}
  	}	



    /*********************************************************************************************************/
	/* modal mostrar todos los productos
	/*********************************************************************************************************/

	
	function buscarNombreProducto(producto) {
  
        $._requestApi('/api/getByNombre', {'search' : producto }, 'GET', function (resolve) {
	        if (resolve) {
	        	var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderProductos(resolve[i]));
                    }
                }
                $('#tbody_productos').html(datos.join(''));
	        	$("#btn_buscar_prod").removeClass('loading');
	    	}
	    });
  	};

	$('.btn_buscar_producto').on('click', function() {
  		$('#buscar_producto_modal').modal('show'); 
  		$('#buscar_producto').val('');
  		//resetearTablaProducto();
  	});	


	$('#buscar_producto').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_prod").addClass('loading');
	    	var producto = $('#buscar_producto').val();
    		buscarNombreProducto(producto);
    	}	
	});

	$('#btn_buscar_prod').on('click', function() {
		$("#btn_buscar_prod").addClass('loading');
    	var producto = $('#buscar_producto').val();
    	buscarNombreProducto(producto);
  	});


    $('body').on('click', '.btn_seleccionar_producto', function(){ 
    	var id = $(this).data("id");
    	$("#loader_busqueda").removeClass('disabled');
		$("#loader_busqueda").addClass('active');
        $._requestApi('/api/getById', {id_producto : id }, 'GET', function (resolve) {
	        if (resolve) {
	        	if (resolve.id_producto) {
		        	agregarTabla(resolve);	
		        }
		        $("#loader_busqueda").removeClass('active');
				$("#loader_busqueda").addClass('disabled');
				$('#buscar_producto_modal').modal('hide'); 
	        }	
	    });
  	});


    /******************************************************************************/
    /* MODAL GOOGLE MAPS
    /******************************************************************************/

    $('.btn_modal_mapa').on('click', function() {
        $('#mapa_modal').modal('show'); 
    }); 

    /******************************************************************************/
    /* MODAL IMAGEN PRODUCTO
    /******************************************************************************/
    
    $('body').on('click', '.btn_imagen_producto', function(){

        $("#nombre_producto").html($(this).data("nombre"));
        $("#precio_producto").html($(this).data("precio"));
        
        if( $(this).data("imagen") == "" ){
            $("#img_producto").attr("src", BASE_URL+'/img/default.jpg');
        }
        else{
            $("#img_producto").attr("src", APP_URL+'/img/productos/'+$(this).data("imagen"));
        }
        
        $('#imagen_modal').modal({
            closable: false
         }).modal('show');
    });


    $('body').on('click', '.btn_close_modal_imagen', function(){
        $('#imagen_modal').modal('close'); 
        $('#buscar_producto_modal').modal('show'); 
    });


    $('body').on('click', '.btn_imagen_producto_2', function(event){

        event.preventDefault();

        $("#nombre_producto_2").html($(this).data("nombre"));
        $("#precio_producto_2").html($(this).data("precio"));
        
        if( $(this).data("imagen") == null ){
            $("#img_producto_2").attr("src", BASE_URL+'/img/default.jpg');
        }
        else{
            $("#img_producto_2").attr("src", APP_URL+'/img/productos/'+$(this).data("imagen"));
        }
        
        $('#imagen_modal_2').modal('show');

        return false
 
    });

	/******************************************************************************/
	/* start: agrega productos a lista
	/******************************************************************************/

	$('[name="id_prod"]').dropdown({
        placeholder: 'Ingrese nombre de producto a buscar',
        direction: 'downward',
        forceSelection : false,
        fields: {
        	remoteValues: 'productos',
        	name: "nombre",
        	value: "id_producto"
        },
     	apiSettings: {
	        method: 'get',
	        cache: false,
	        url: APP_URL + '/api/productos/{query}',
	    },

	    onChange: function(value, text, $selectedItem) {

	    	 $._requestApi('/api/getById', {id_producto : value }, 'GET', function (resolve) {
		        if (resolve) {
		        	if (resolve.id_producto) {
			        	agregarTabla(resolve);	
			        	
			        }
		        }	
		    });  
	    }
	});
  	


 	function agregarTabla(data) {
  		if (verificaExite(data.id_producto)) {
  			cant = parseFloat($('#cant'+data.id_producto_local).val());
  			$('#cant'+data.id_producto_local).val(cant + 1);
  			calculaSubtotal(data.id_producto_local, data.producto.valor_impuesto);
  			calcularTotal();

  		} else {
  			agregarFila(data);
  		}
        
  	}


  	function agregarFila(data) {

		var nuevoProducto=''+
            '<tr class="rows" id="'+data.id_producto+'">'+
                '<td><input type="hidden" name="id_producto[]" value="'+data.id_producto+'"/>  <a href="" data-nombre="'+data.producto.nombre+'" data-imagen="'+data.producto.url_imagen+'" data-precio="'+data.producto.precio+'" class="btn_imagen_producto_2"> '+data.producto.nombre+' '+(data.producto.descripcion !== null ? data.producto.descripcion : '')+ '</a></td>'+
                '<td><input type="text" name="cantidad[]" class="cant '+data.id_producto_local+'" id="cant'+data.id_producto_local+'" value="1" size="1"></td>'+
                '<td><input type="hidden" readonly class="prec '+data.id_producto_local+'"  name="precio_venta[]" id="prec'+data.id_producto_local+'" value="'+data.producto.precio+'" size="2"/><span">'+data.producto.precio+'</span></td>'+
                '<td style="display:none"><input type="hidden" name="descuento[]" class="desc '+data.id_producto_local+'" id="desc'+data.id_producto_local+'" value="0" size="1"></td>'+ 
                '<td style="display:none"><input type="hidden" name="impuesto[]" class="impu '+data.producto.valor_impuesto+'" id="impu'+data.id_producto_local+'" value="'+(data.producto.precio-(data.producto.precio/(1+(data.producto.valor_impuesto/100)))).toFixed(2)+'"/></td>'+
                '<td class="positive"><input type="hidden" name="subtotal[]" id="subt'+data.id_producto_local+'" value="'+data.producto.precio+'"/><span id="v_subt'+data.id_producto_local+'">'+data.producto.precio+'</span></td>'+
                '<td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").append(nuevoProducto);

        calcularTotal(); 
  	}

	/*********************************************************************************************************/
	/* start: calcula precios al presionar tecla
	/*********************************************************************************************************/

  	$('body').on('keyup', '.cant', function(){

  		$(this).val($(this).val().trim());
    	var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
	    
    });

});

/*********************************************************************************************************/
/* funciones de calculo
/*********************************************************************************************************/

function calculaSubtotal(id, imp) { 
	var subt = (parseFloat($('#prec'+id).val()).toFixed(4)*parseFloat($('#cant'+id).val()).toFixed(4)) - parseFloat($('#desc'+id).val()).toFixed(2);
	$('#subt'+id).val(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    $('#v_subt'+id).text(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    calculaImpuesto(id, imp);
}

function calculaImpuesto(id, v_impu) {
	var impu = parseFloat($('#subt'+id).val()).toFixed(2) - parseFloat($('#subt'+id).val()).toFixed(2)/(1+(v_impu/100));
	$('#impu'+id).val(validaNumero($('#subt'+id).val()) && !isNaN(impu) ? impu.toFixed(2) : '');
}

function calculaAdelanto(total, adelanto) { 
	var saldo = total-adelanto;
	$('#saldo').val(validaNumero(adelanto) && validaNumero(saldo) && (saldo > 0) ? saldo.toFixed(2) : '0.00');
}

function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function verificaExite(id) {
	exist = false;
	$('#tbody tr').each(function() {
    	if (this.id == id) {
    		exist = true;
    	}
  	});

	return exist;
}

function calcularTotal() {
	var total = 0;
	$('#tbody').find('tr').each(function(index, element) {
	    $(element).find('td').each(function(index1, element1) {
	        if(index1==5) { //Index empieza en 1
	            temp = parseFloat($(element1).text());
	            total+= temp;
	        }
	    });
	});
	$('.total_venta').val(!isNaN(total) ? total.toFixed(2) : '');
}

function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
    calcularTotal();
}

/*********************************************************************************************************/
/* funciones de busqueda de productos
/*********************************************************************************************************/


function renderProductos(resolve){
	var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_producto+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.producto.nombre,' ',resolve.producto.descripcion,'</td>',
            '<td>',resolve.producto.precio,'</td>',
            '<td>', (resolve.stock < 1000001 ? "AGOTADO" : resolve.stock - 1000000 ) ,'</td>',
            '<td><div class="ui mini vertical animated orange button btn_imagen_producto" title="Ver imagen del producto" data-nombre="',resolve.producto.nombre,'" data-imagen="',resolve.producto.url_imagen,'" data-precio="',resolve.producto.precio,'"><div class="hidden content">Ver</div><div class="visible content"><i class="search icon"></i></div></div></td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="',resolve.id_producto,'" data-stock="',resolve.stock,'" data-precio="',resolve.producto.precio,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}


var marker;

function load_map() {


    var latlng = new google.maps.LatLng(-11.932576022332931, -76.94977420377566);

    var mapOptions = {
        zoom: 10,
        center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP,
    };

    map = new google.maps.Map(document.querySelector("#map"), mapOptions);

    // Create the initial InfoWindow.
    var infoWindow = new google.maps.InfoWindow({
      content: 'Ubique su domicilio en el mapa', 
      position: latlng
    });
    infoWindow.open(map);


    google.maps.event.addListener(map, 'click', function(event) {
        infoWindow.close();
        $('#latitud').val(event.latLng.lat().toFixed(8));
        $('#longitud').val(event.latLng.lng().toFixed(8));
        placeMarker(event.latLng);
    });

}

function placeMarker(location) {
    
    if (marker == undefined){
        marker = new google.maps.Marker({
            position: location,
            map: map, 
            animation: google.maps.Animation.DROP,
            draggable: false,
            icon: BASE_URL+"/img/marker_bus.png"
        });
        var infowindow = new google.maps.InfoWindow();
        infowindow.setContent('(Latitud : ' + location.lat().toFixed(4) + ') , (Longitud : ' + location.lng().toFixed(4)+')');
        infowindow.open(map, marker);
    }
    else{
        marker.setPosition(location);
    }

}


function getDatosLocal() {

    axios.get(`${APP_URL}/api/getLocal`)
        .then(res => {
            $('#direccion_empresa').html(res.data.direccion);
            $('#telefono_empresa').html(res.data.telefono);
        })
}

function getDatosEmpresa() {

    axios.get(`${APP_URL}/api/getEmpresa`)
        .then(res => {
            $('#razon_social_empresa').html(res.data.razon_social);
            $('#ruc_empresa').html(res.data.ruc);
        })
}

function getProductos() {
    
    $._requestApi('/api/getProductos', {}, 'GET', function (resolve) {
        if (resolve) {

            var datos = [];
            for( var i=0; i< resolve.length; i++ ){
                resolve[i]['i'] = i+1;
                if(resolve[i]){
                    datos.push(renderProductos(resolve[i]));
                }
            }
            $('#tbody_productos').html(datos.join(''));

        }
    });


}