<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleCompraTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_compra', function (Blueprint $table) {
            $table->integer('id_detalle_compra')->autoIncrement();
            $table->integer('id_compra');
            $table->integer('id_producto');
            $table->decimal('cantidad', 9, 2);
            $table->decimal('precio_compra_unitario', 9, 2);
            $table->decimal('precio_compra_total', 9, 2);
            $table->decimal('precio_venta_unitario', 9, 2);
            $table->decimal('utilidad', 9, 2);
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            
            $table->foreign('id_producto')->references('id_producto')->on('productos'); 
            $table->foreign('id_compra')
                  ->references('id_compra')->on('compras')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_compra');
    }
}
