<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Egreso extends Model
{
    protected $table = 'egresos';
    protected $primaryKey = 'id_egreso';

    protected $fillable = [
        'id_egreso', 'id_local', 'id_usuario', 'tipo_egreso','concepto', 'descripcion', 'tipo_comprobante', 'numero_comprobante', 'monto', 'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
}
