<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Venta;
use App\Models\DetalleVenta;
use App\Models\Empresa;
use App\Models\Nota;


class ElectronicoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function listar_facturas()
    {
        $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 1)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('electronico.listar_facturas', [ 'data' => $res]); 
    }

    public function estado_facturas($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'REGISTRADO'];

        $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 1)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('electronico.listar_facturas', [ 'data' => $res]); 
    }

    public function detalles($id)
    {
        return view('electronico.detalles', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where(['id_venta' => $id , 'estado' => 1])->first(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
            'detalle_venta' => DetalleVenta::with(['producto'])->where(['id_venta' => $id , 'estado' => 1])->get(),
        ]); 
    }

    public function listar_boletas()
    {
        $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 2)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('electronico.listar_boletas', [ 'data' => $res]); 
    }

    public function estado_boletas($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'PENDIENTE', 'REGISTRADO'];

        $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 2)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('electronico.listar_boletas', [ 'data' => $res]); 
    }





}