<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Venta;
use App\Models\Nota;
use App\Models\Local;
use App\Models\Cliente;
use App\Models\Producto;
use App\Models\Usuario;
use App\Models\ProductoLocal;
use App\Models\DetalleVenta;
use App\Models\TipoComprobante;
use App\Models\TipoDocumento;
use App\Models\TipoPresentacion;
use App\Models\UnidadMedida;
use App\Models\Proforma;
use App\Models\DetalleProforma;
use App\Http\Controllers\XmlController;

class ContingenciaController extends Controller
{
	public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function listar()
    {
	 	$res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_nota', null)->where('id_cliente', '<>', null)->where('estado', 1)->where('contingencia', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('contingencia.listar', [ 'data' => $res]); 
	}
   

	public function nuevo()
    {
	 	//$correl = $this->getCorrel(2, Auth::guard("usuario")->user()->id_local);
        $id_local = Auth::guard("usuario")->user()->id_local;
        $data = [
	 		'locales' => Local::where('estado', 1)->get(), 
	 		'clientes' => Cliente::where('estado', 1)->orderBy('nombre', 'ASC')->limit(20)->get(), 

            'productos' => ProductoLocal::with('producto')->where('id_local', $id_local)->where('estado', 1)->where('stock', '>', 0)->limit(20)->get(),

	 		'producto' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(20)->get(),
	 		'tipo_documento' => TipoDocumento::all(), 
	 		'tipo_comprobante' => TipoComprobante::where('grupo', 1)->get(), 
	 		'tipo_presentacion' => TipoPresentacion::all(), 
	 		'unidad_medida' => UnidadMedida::all(), 

	 	];
	 	return view('contingencia.nuevo', $data); 
	}


	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $comprobante = Venta::where(['serie_comprobante' => $request->serie_comprobante, 'numero_comprobante' => $request->numero_comprobante, 'id_tipo_comprobante' => $request->id_tipo_comprobante, 'contingencia' => 1])->get();

            if (count($comprobante) > 0) {
                $res['message'] = 'error';
                $res['comment'] = 'El comprobante N° '.$comprobante[0]->nombre_comprobante.' ya fue registrado anteriormente!';

                return response()->json($res);
            }
            else {
                if(!is_null($request->numero_documento) && !is_null($request->nombre)){

                    $buscar = Cliente::where('numero_documento', $request->numero_documento)->first();

                    if ($buscar) {

                        $request->request->add(['id_cliente' => $buscar->id_cliente]);

                        if ($buscar->id_cliente != 1) {
                            $cli = Cliente::find($buscar->id_cliente);
                            $cli->nombre = $request->nombre;
                            $cli->direccion = $request->direccion;
                            $cli->save();  
                        }
                        else{
                            $request->request->add(['observacion' => $request->direccion]);
                        }
                          
                    }
                    else{
                        $data = [
                            'nombre' => $request->nombre,
                            'numero_documento' => $request->numero_documento,
                            'id_tipo_documento' => $request->id_tipo_documento,
                            'direccion' => $request->direccion
                        ];
                        $cli = Cliente::create($data); 
                        $request->request->add(['id_cliente' => $cli->id_cliente]);
                    }
                    
                } else {
                    $request->request->add(['id_cliente' => 1]);
                    $request->request->add(['observacion' => $request->direccion]);
                }

                $id_local = Auth::guard("usuario")->user()->id_local;
              
                $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
                $request->request->add(['id_local' => $id_local]);
                $nombre_comprobante = $request->serie_comprobante."-".$request->numero_comprobante;
                $request->request->add(['nombre_comprobante' => $nombre_comprobante ]);
                //$request->request->add(['fecha_venta' => date('Y-m-d')]);
                $request->request->add(['estado_envio' => 'REGISTRADO']);
                $request->request->add(['mensaje_envio' => 'La venta fue registrada correctamente']);

                $res = Venta::create($request->all());
                
                if ($res) 
                {
                    for( $i = 0; $i < count($request->id_producto); $i++)
                    {
                        $detalle_venta= [
                            'id_venta' => $res->id_venta, 
                            'id_producto' => $request->id_producto[$i], 
                            'cantidad' => $request->cantidad[$i], 
                            'precio_venta' => $request->precio_venta[$i], 
                            'impuesto' => $request->impuesto[$i], 
                            'precio_venta_neto' => number_format($request->subtotal[$i]-$request->impuesto[$i], 2, '.', ''), 
                            'descuento' => $request->descuento[$i], 
                            'precio_venta_total' => $request->subtotal[$i], 
                        ];

                        $res1 = DetalleVenta::create($detalle_venta);

                        if ($res1) 
                        {
                            $producto_local = ProductoLocal::where(['id_producto' => $request->id_producto[$i] , 'id_local' => $id_local, 'estado' => 1])->get();
                            $prod = ProductoLocal::find($producto_local[0]->id_producto_local);
                            $prod->stock = $producto_local[0]->stock - $request->cantidad[$i];
                            $prod->save();

                            $produ = Producto::find($request->id_producto[$i]);
                            if (is_null($produ->precio_compra)) {
                                $produ->precio_compra = 0;
                            }
                            $produ->precio = $request->precio_venta[$i];
                            $produ->utilidad= (($request->precio_venta[$i] - $produ->precio_compra) < 0 ) ? 0 : ($request->precio_venta[$i] - $produ->precio_compra);
                            $produ->save();
                        }
                    }

                    //Creamos documentos XML
                    $xml = new XmlController();
                    $xml->crearComprobante($res->id_venta);    
                }
                
                $res ? $res['message'] = 'success' : $res['message'] = 'error';

                return response()->json($res);
                
            }     
        }
	}

    public function detalles($id)
    {
        return view('contingencia.detalles', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where(['id_venta' => $id])->first(),
            'detalle_venta' => DetalleVenta::with(['producto'])->where(['id_venta' => $id])->get(),
        ]); 
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id1 = Cliente::where('nombre', 'LIKE', '%'.$request->search.'%')->orWhere('numero_documento', $request->search)->first();
            $id2 = Local::where('nombre', 'LIKE', '%'.$request->search.'%')->first();
            $id3 = TipoComprobante::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

            $res =  Venta::with(['local', 'cliente'])->where(function ($query) {
                    $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('contingencia', 1)->where('id_cliente','<>', null);
                })->where(function ($query)  use ($request, $id1 ,$id2 ,$id3) {
                    $query->where('total_venta', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('tipo_pago', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('fecha_venta', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('serie_comprobante', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('numero_comprobante', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('nombre_comprobante', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('estado_envio', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('id_cliente', '=', $id1 ? $id1->id_cliente : '')
                          ->orWhere('id_local', '=', $id2 ? $id2->id_local : '')
                          ->orWhere('id_tipo_comprobante', '=', $id3 ? $id3->id_tipo_comprobante : '');
                })->paginate(10);
            
            $res->appends(['search' => $request->search]); 
            return view('contingencia.listar', [ 'data' => $res]); 

        }
    }


    public function nuevo_credito($id)
    {
        return view('contingencia.nuevo_credito', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where('id_nota' , null)->where(['id_venta' => $id, 'contingencia' => 1])->first(),
        ]); 
    }

    public function registrar_credito(Request $request)
    {
        if ($request->ajax())
        {    

            $nota = Nota::where(['serie_nota' => $request->serie_nota, 'numero_nota' => $request->numero_nota, 'id_tipo_comprobante' => $request->id_tipo_comprobante, 'contingencia' => 1])->get();

            if (count($nota) > 0) {
                $res['message'] = 'error';
                $res['comment'] = 'La nota de credito N° '.$nota[0]->nombre_nota.' ya fue emitida anteriormente!';

                return response()->json($res);
            }
            else {
                
                $prev = Venta::where('id_nota' , null)->where(['id_venta' => $request->id_venta])->first();

                if ($prev) {
                    
                    $nombre = $request->serie_nota."-".$request->numero_nota;
                    $id_local = Auth::guard("usuario")->user()->id_local;

                    $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
                    $request->request->add(['id_local' => $id_local]);
                    $request->request->add(['nombre_nota' => $nombre]);

                    $request->request->add(['estado_envio' => 'REGISTRADO']);
                    $request->request->add(['mensaje_envio' => 'La nota fue emitida correctamente']);

                    $res = Nota::create($request->all());

                    if ($res) {

                        $data = Venta::find($res->id_venta);
                        $data->id_nota = $res->id_nota; 
                        $data->save();

                        $data2 = DetalleVenta::where('id_venta', $request->id_venta)->get();
                        foreach ($data2  as $row) {
                            $data2 = ProductoLocal::where(['id_producto' => $row->id_producto, 'id_local' => $request->id_local])->first();
                            $res2 = ProductoLocal::find($data2->id_producto_local);
                            $res2->stock  = $data2->stock + $row->cantidad; 
                            $res2->save();
                        }

                        $xml = new XmlController();
                        $xml->crearNotaCredito($res->id_nota); 
                    }

                    $res ? $res['message'] = 'success' : $res['message'] = 'error';
                }    
                else {
                    $res['message'] = 'error';
                    $res['comment'] = 'La nota de credito ya fue emitida anteriormente!';
                }

                return response()->json($res); 
            }
        }
    }

    public function listar_anulados()
    {
        $res = Venta::with(['local', 'cliente', 'tipo_comprobante', 'nota'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_nota', '<>',null)->where('id_cliente', '<>', null)->where('estado', 1)->where('contingencia', 1)->orderBy('updated_at', 'desc')->paginate(20);

        return view('contingencia.listar_anulados', [ 'data' => $res]); 
    }



}
