<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Compra;
use App\Models\Local;
use App\Models\Proveedor;
use App\Models\Producto;
use App\Models\Usuario;
use App\Models\ProductoLocal;
use App\Models\DetalleCompra;
use App\Models\TipoDocumento;
use App\Models\TipoPresentacion;
use App\Models\UnidadMedida;
use App\Models\Empresa;

class CompraController extends Controller
{
	public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function listar()
    {
	 	$res = Compra::with(['local', 'proveedor'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('compra.listar', [ 'data' => $res]); 
	}

	public function listar_anulados()
    {
	 	$res = Compra::with(['local', 'proveedor'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 0)->orderBy('created_at', 'desc')->paginate(10);

        return view('compra.listar_anulados', [ 'data' => $res]); 
	}

	public function nuevo()
    {
	 	$data = [
	 		'locales' => Local::where('estado', 1)->get(), 
	 		'empresa' => Empresa::where('estado', 1)->first(), 
	 		'proveedores' => Proveedor::where('estado', 1)->get(), 
	 		/*'productos' => Producto::where('estado', 1)->limit(20)->get(),  */

	 		'productos' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->limit(20)->get(),
	 		
	 		'tipo_documento' => TipoDocumento::all(), 
	 		'tipo_presentacion' => TipoPresentacion::all(), 
	 		'unidad_medida' => UnidadMedida::all(), 
	 	];
	 	return view('compra.nuevo', $data); 
	}

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
			$request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
			$request['total_compra'] = $request->total_compra*$request->valor_cambio;
            $id_compra = Compra::create($request->all())->id_compra;

            if ($id_compra) 
            {
	        	for( $i = 0; $i < count($request->id_producto); $i++)
	            {
	                $detalle_compra = [
	                	'id_compra' => $id_compra, 
	                	'id_producto' => $request->id_producto[$i], 
			        	'cantidad' => $request->cantidad[$i], 
			        	'precio_compra_unitario' => $request->precio_compra_unitario[$i]*$request->valor_cambio, 
			        	'precio_compra_total' => $request->precio_compra_total[$i]*$request->valor_cambio, 
			        	'precio_venta_unitario' => $request->precio_venta_unitario[$i], 
			        	'utilidad' => (($request->precio_venta_unitario[$i]-$request->precio_compra_unitario[$i]*$request->valor_cambio) > 0 ) ? ($request->precio_venta_unitario[$i]-$request->precio_compra_unitario[$i]*$request->valor_cambio) : 0, 
	                ];

	                $res1 = DetalleCompra::create($detalle_compra);

	                if ($res1) 
	                {
	                	$prod = Producto::find($res1->id_producto);
		                $prod->precio = $res1->precio_venta_unitario;
		                $prod->precio_compra = $res1->precio_compra_unitario;
		                $prod->utilidad = $res1->utilidad;
		                $prod->save();
	                }
		        }    
	        }
	        
	        if ($res1) {
	        	$res2 = $this->registrarProductoLocal($request);
	        	$res3['id_compra'] = $id_compra; 
	        }

	        $res3 ? $res3['message'] = 'success' : $res3['message'] = 'error';
	        
            return response()->json($res3); 

        }
	}

	public function registrarProductoLocal($request)
    {
		for( $i = 0; $i < count($request->id_producto); $i++)
	    {
			$producto_local = ProductoLocal::where(['id_producto' => $request->id_producto[$i] , 'id_local' => $request->id_local, 'estado' => 1])->get();

	        if (count($producto_local) > 0) 
	        {
	            $data = ProductoLocal::find($producto_local[0]->id_producto_local);
	            $data->stock  = $producto_local[0]->stock + $request->cantidad[$i];
	            $res = $data->save();
	        } 
	        else 
	        {
	        	$detalle_producto_local = [
	        		'id_local' => $request->id_local, 
	            	'id_producto' => $request->id_producto[$i], 
	            	'stock' => 1000000 + $request->cantidad[$i],
	            ];
	            $res = ProductoLocal::create($detalle_producto_local);
	        }
	    }  

	    return $res;  
	}


	public function detalles($id)
    {
        return view('compra.detalles', [
            'data' => Compra::with(['local', 'proveedor', 'usuario'])->where(['id_compra' => $id ])->first(),
            'detalle_compra' => DetalleCompra::with(['producto'])->where(['id_compra' => $id ])->get(),
        ]); 
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id1 = Proveedor::where('nombre', 'LIKE', '%'.$request->search.'%')->orWhere('numero_documento', $request->search)->first();
            $id2 = Local::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

	 		$res =  Compra::with(['local', 'proveedor'])->where(function ($query) {
                    $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1);
                })->where(function ($query)  use ($request, $id1 ,$id2) {
                    $query->where('total_compra', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('tipo_compra', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('fecha_compra', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('id_proveedor', '=', $id1 ? $id1->id_proveedor : '')
                          ->orWhere('id_local', '=', $id2 ? $id2->id_local : '');
                })->paginate(10);
		 	
		 	$res->appends(['search' => $request->search]); 
	        return view('compra.listar', [ 'data' => $res]); 

        }
    }

    public function anular(Request $request)
    {
        if ($request->ajax())
        {
            $data = Compra::find($request->id_compra);
            $data->estado  = 0; 
            $data->id_usuario = Auth::guard("usuario")->user()->id_usuario;
            $data->save();

            $detalles = DetalleCompra::where('id_compra', $request->id_compra)->get();

            foreach ($detalles as $row) {
            	$data1 = DetalleCompra::find($row->id_detalle_compra);
            	$data1->estado  = 0; 
            	$data1->save();

            	$data2 = ProductoLocal::where(['id_producto' => $row->id_producto, 'id_local' => $request->id_local])->first();
            	$res = ProductoLocal::find($data2->id_producto_local);
            	$res->stock  = $data2->stock - $row->cantidad; 
            	$res->save();
            }


            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }


    public function listar_deuda()
    {
	 	$res = Compra::with(['local', 'proveedor'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('fecha_pago','<>', null)->where('tipo_compra', 'CREDITO')->orderBy('created_at', 'desc')->paginate(10);

        return view('compra.listar_deuda', [ 'data' => $res]); 
	}

	public function detalles_deuda($id)
    {
        return view('compra.detalles_deuda', [
            'data' => Compra::with(['local', 'proveedor', 'usuario'])->where(['id_compra' => $id ])->first(),
            'detalle_compra' => DetalleCompra::with(['producto'])->where(['id_compra' => $id ])->get(),
        ]); 
    }

    public function anular_deuda(Request $request)
    {
        if ($request->ajax())
        {
            $data = Compra::find($request->id_compra);
            $data->fecha_pago = null; 
            $data->tipo_compra = 'CONTADO'; 
            //$data->id_usuario = Auth::guard("usuario")->user()->id_usuario;
            $data->save();

            return response()->json($data ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

}
